<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Groups', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Explicitly set InnoDB for foreign keys
            $table->bigIncrements('Group_id');
            $table->string('Name', 255);
            $table->text('Description')->nullable();
            $table->unsignedBigInteger('Created_by');
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->foreign('Created_by')->references('User_id')->on('Users')->onDelete('cascade');
            $table->index('Created_by', 'Idx_created_by');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('Groups');
    }
};
